#|______________________________________________________________________________
 |
 | plots002.lsp
 |
 | Constructor functions to show distribution shape
 |
 |   hollow-histogram 
 |   dynamic-histogram
 |   distribution-plot
 |   cumulative-plot    (quantile-plot and normal-probability-plot)    
 |   comparison-plot    (quantile-quantile plot)
 |______________________________________________________________________________
 |#


(defun hollow-histogram (&optional data &rest args &key (histo t) (hollow t)
                                    (title "Hollow HistoGram"))
"HOLLOW-HISTOGRAM makes hollow frequency histogram plots (and frequency polygons or dynamic histograms) from raw data, based on frequencies calculated by binning values of a numeric variable.  The formation of the bins is under the control of the user and may be changed dynamically via buttons on the plot.

ARGUMENTS:
&optional data &key binwidth origin cutpoints (histo t) prob (hollow t) (new-x t) (new-y t) (bottom-tool-bar t) sort 

(ok-var-types '(numeric )) variable-labels (show t) (top-most t) (linked t) (location '(50 50)) (size '(320 320)) (title \"Hollow Histogram\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil)

HISTO PROB BINWIDTH ORIGIN CUTPOINTS SORT BOTTOM-TOOL-BAR 
The initial plot is a hollow frequency histogram since, by default, HISTO is T and HOLLOW is T. The y-axis is initially probabilities if PROB is T, frequencies otherwise.

BINWIDTH ORIGIN CUTPOINTS 
Each of these must each be a list of values, one for each variable. Any given value may be nil. If not used the values will be calculated.  

BOTTOM-TOOL-BAR NEW-X NEW-Y
When T buttons appear on a bar at the bottom. When NEW-X is T then a new-x button is put on tool-bar (default nil) to enable plotting variables other than the first;  When NEW-Y is T then a new-y button is put on the tool-bar to control y-axis representing frequencies or probabilities (default t).

GENERAL PLOT ARGUMENTS:
DATA may be nil, an object, a list, a vector, a list of lists, a list of vectors, or a matrix. If not specified, DATA is assumed to be and is converted to a list of vectors, one vector for each of the OK-VAR-TYPES variables in the current-data. Plot is of the first variable, initially, with the other variables available for plotting. The plot appears (or is prepared to appear if SHOW is NIL) in container IN, where IN is *DEFAULT-GRAPHICS-CONTAINER* if IN is not specified, the \"desktop\" if IN is T (i.e., popped out of *DEFAULT-GRAPHICS-CONTAINER*), the XLispStat window if IN is specified to be NIL, and container C if IN is specified to be the container window C. Unless CONTENT-ONLY is t, the plot will include variable-labels and legends, as specified. The plot will have a close box which will be de-activated when GO-AWAY is T. When CONTENT-ONLY is T the button bars, axes, legends and overlays do not appear. When HELP-BAR is NIL the help-bar does not appear. When POP-UP is NIL the pop-up menus are not available."  
 (apply #'histofreq-plots data :histo histo :hollow hollow :title title args))


(defun dynamic-histogram (&optional data &rest args &key (histo t) (hollow nil)
                                    (title "Dynamic HistoGram"))
"DYNAMIC-HISTOGRAM makes dynamic frequency histogram plots (and frequency polygons or hollow histograms) from raw data, based on frequencies calculated by binning values of a numeric variable.  The formation of the bins is under the control of the user and may be changed dynamically via buttons on the plot.

ARGUMENTS:
&optional data &key binwidth origin cutpoints (histo t) prob (hollow t) (new-x t) (new-y t) (bottom-tool-bar t) sort 

(ok-var-types '(numeric )) variable-labels (show t) (top-most t) (linked t) (location '(50 50)) (size '(320 320)) (title \"Dynamic Histogram\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil)

HISTO PROB BINWIDTH ORIGIN CUTPOINTS SORT BOTTOM-TOOL-BAR 
The initial plot is a hollow frequency histogram since, by default, HISTO is T and HOLLOW is T. The y-axis is initially probabilities if PROB is T, frequencies otherwise.

BINWIDTH ORIGIN CUTPOINTS 
Each of these must each be a list of values, one for each variable. Any given value may be nil. If not used the values will be calculated.  

BOTTOM-TOOL-BAR NEW-X NEW-Y
When T buttons appear on a bar at the bottom. When NEW-X is T then a new-x button is put on tool-bar (default nil) to enable plotting variables other than the first;  When NEW-Y is T then a new-y button is put on the tool-bar to control y-axis representing frequencies or probabilities (default t).

GENERAL PLOT ARGUMENTS:
DATA may be nil, an object, a list, a vector, a list of lists, a list of vectors, or a matrix. If not specified, DATA is assumed to be and is converted to a list of vectors, one vector for each of the OK-VAR-TYPES variables in the current-data. Plot is of the first variable, initially, with the other variables available for plotting. The plot appears (or is prepared to appear if SHOW is NIL) in container IN, where IN is *DEFAULT-GRAPHICS-CONTAINER* if IN is not specified, the \"desktop\" if IN is T (i.e., popped out of *DEFAULT-GRAPHICS-CONTAINER*), the XLispStat window if IN is specified to be NIL, and container C if IN is specified to be the container window C. The plot will include variable-labels and legends, as specified. The plot will have a close box which will be de-activated when GO-AWAY is T. When CONTENT-ONLY is T the button bars, legends and overlays do not appear. When HELP-BAR is NIL the help-bar does not appear. When POP-UP is NIL the pop-up menus are not available."  
 (apply #'histofreq-plots data :histo histo :hollow hollow :title title args))


(defun distribution-plot (&optional data &rest args &key (histo nil) (hollow nil) 
                                    (title "Distribution Plot"))
"DISTRIBUTION-PLOT makes dynamic frequency distribution plots (and dynamic histograms or hollow histograms) from raw data, based on frequencies calculated by binning values of a numeric variable.  The formation of the bins is under the control of the user and may be changed dynamically via buttons on the plot.

ARGUMENTS:
&optional data &key binwidth origin cutpoints (histo t) prob (hollow t) (new-x t) (new-y t) (bottom-tool-bar t) sort 

(ok-var-types '(numeric )) variable-labels (show t) (top-most t) (linked t) (location '(50 50)) (size '(320 320)) (title \"Dynamic Histogram\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil)

HISTO PROB BINWIDTH ORIGIN CUTPOINTS SORT BOTTOM-TOOL-BAR 
The initial plot is a hollow frequency histogram since, by default, HISTO is T and HOLLOW is T. The y-axis is initially probabilities if PROB is T, frequencies otherwise.

BINWIDTH ORIGIN CUTPOINTS 
Each of these must each be a list of values, one for each variable. Any given value may be nil. If not used the values will be calculated.  

BOTTOM-TOOL-BAR NEW-X NEW-Y
When T buttons appear on a bar at the bottom. When NEW-X is T then a new-x button is put on tool-bar (default nil) to enable plotting variables other than the first;  When NEW-Y is T then a new-y button is put on the tool-bar to control y-axis representing frequencies or probabilities (default t).

GENERAL PLOT ARGUMENTS:
DATA may be nil, an object, a list, a vector, a list of lists, a list of vectors, or a matrix. If not specified, DATA is assumed to be and is converted to a list of vectors, one vector for each of the OK-VAR-TYPES variables in the current-data. Plot is of the first variable, initially, with the other variables available for plotting. The plot appears (or is prepared to appear if SHOW is NIL) in container IN, where IN is *DEFAULT-GRAPHICS-CONTAINER* if IN is not specified, the \"desktop\" if IN is T (i.e., popped out of *DEFAULT-GRAPHICS-CONTAINER*), the XLispStat window if IN is specified to be NIL, and container C if IN is specified to be the container window C. The plot will include variable-labels and legends, as specified. The plot will have a close box which will be de-activated when GO-AWAY is T. When CONTENT-ONLY is T the button bars, legends and overlays do not appear. When HELP-BAR is NIL the help-bar does not appear. When POP-UP is NIL the pop-up menus are not available."  
 (apply #'histofreq-plots data :histo histo :hollow hollow :title title args))

(defun histofreq-plots
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect t) 
             (location '(50 50)) (size '(320 320))
             (title "Distribution Plot") 
             (legend1 "Unnamed Data") (legend2 nil)
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???)
             ;following are unique to this plot
             binwidth origin cutpoints histo prob hollow
             (new-x t) (new-y t) (bottom-tool-bar t)  sort)

"HISTOFREQ-PLOTS makes frequency polygons, dynamic histograms and hollow histogram from raw data, based on frequencies calculated by binning values of a numeric variable.  The formation of the bins is under the control of the user and may be changed dynamically via buttons on the plot.

ARGUMENTS:
&optional data &key binwidth origin cutpoints histo prob hollow (new-x t) (new-y t) (bottom-tool-bar t) sort 

(ok-var-types '(numeric )) variable-labels (show t) (top-most t) (linked t) (location '(50 50)) (size '(320 320)) (title \"Frequency Polygon\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil)

HISTO PROB BINWIDTH ORIGIN CUTPOINTS SORT BOTTOM-TOOL-BAR 
The initial plot is a frequency polygon unless HISTO is T, in which case it is a histogram. An initial histogram is hollow when HOLLOW is T. The y-axis is initially probabilities if PROB is T, frequencies otherwise.

BINWIDTH ORIGIN CUTPOINTS 
Each of these must each be a list of values, one for each variable. Any given value may be nil. If not used the values will be calculated.  

BOTTOM-TOOL-BAR NEW-X NEW-Y
When T buttons appear on a bar at the bottom. When NEW-X is T then a new-x button is put on tool-bar (default nil) to enable plotting variables other than the first;  When NEW-Y is T then a new-y button is put on the tool-bar to control y-axis representing frequencies or probabilities (default t).

GENERAL PLOT ARGUMENTS:
DATA may be nil, an object, a list, a vector, a list of lists, a list of vectors, or a matrix. If not specified, DATA is assumed to be and is converted to a list of vectors, one vector for each of the OK-VAR-TYPES variables in the current-data. Plot is of the first variable, initially, with the other variables available for plotting. The plot appears (or is prepared to appear if SHOW is NIL) in container IN, where IN is *DEFAULT-GRAPHICS-CONTAINER* if IN is not specified, the \"desktop\" if IN is T (i.e., popped out of *DEFAULT-GRAPHICS-CONTAINER*), the XLispStat window if IN is specified to be NIL, and container C if IN is specified to be the container window C. The plot will include variable-labels and legends, as specified. The plot will have a close box which will be de-activated when GO-AWAY is T. When CONTENT-ONLY is T the button bars, legends and overlays do not appear. When HELP-BAR is NIL the help-bar does not appear. When POP-UP is NIL the pop-up menus are not available."
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (fourth graph-data))
         (linkable nil)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (setf graph
          (send histofreq-proto :new graph-data 
                :variable-labels variable-labels 
                :show nil                        :top-most top-most
                :container container             :pop-out pop-out
                :location location               :size size 
                :menu menu                       :title title 
                :legend1 legend1                 :legend2 legend2
                :go-away go-away                 :content-only content-only
                ;MODULE-SPECIFIC ARGUMENTS
                :poly (not histo) :prob prob 
                :binwidth binwidth :origin origin :cutpoints cutpoints 
                :new-x new-x :new-y new-y :bottom-tool-bar bottom-tool-bar))
    (when graph
          (when (and (not hollow) histo) 
                (send graph :switch-plot-type)
                (send graph :switch-plot-type))
          (send graph :title title)
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          (send graph :make-two-plot-menus
                "HistoFrq"
                :hotspot-items '(help dash new-x new-y dash
                              show-plots hide-plots close-plots dash 
                              create-data dash 
                              print save copy dash
                              on-top maximize)
                :popup-items   '(showing-labels mouse))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable linked
                data-object content-only))
    graph))

(defun cumulative-plot

  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels  variable-label
             (show t) (top-most t) (linked t) (connect t) 
             (location '(50 50)) (size '(320 320))
             (title "Cumulative Plot") 
             (legend1 "Unnamed Data") (legend2 nil)
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???)
             ;following are unique to this plot
             (points t) (pop-up t) (help-bar t) (reg-line t))
            
"CUMULATIVE PLOT makes quantile plots and normal probability plots of numeric variables to show the shape of the data's cumulative distribution

ARGUMENTS:
&optional data &key (points t) (pop-up t) (help-bar t) (reg-line t) (ok-var-types '(numeric )) variable-labels  point-labels (show t)  (top-most t) (linked t) (connect t) (location '(50 50)) (size '(320 320)) (title \"Cumulative Plot\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil) 

DATA is nil, a data object, a sequence or a list of sequences. Makes quantile plot of the sequence or first sequence. A connected point plot is produced when POINTS and CONNECT is T (default).  A unconnected point plot is produced if POINTS is T and CONNECT is NIL. A line plot is produced if POINTS is NIL, regardless of CONNECT. When REG-LINE is t a regression line is to be added to the plot.  Range and tick-marks for y are determined by get-nice-range unless NICE-RANGE (list of min, max, num tick marks) is specified. Remaining arguments are the same as for scatterplots. Function written by Forrest Young to replace original by Luke Tierney."
(when (not variable-labels) (setf variable-labels variable-label))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types))
         (data-object (fourth graph-data))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (unless points (setf connect t))
    (setf graph
          (send quantile-plot-proto :new graph-data 
                :npplot T
                :title title 
                :point-labels point-labels
                :variable-labels variable-labels
                :reg-line reg-line
                :points points
                :connect connect
                :location location 
                :size size
                :go-away go-away 
                :show nil
                :legend1 legend1 
                :legend2 legend2 )
          )
    (when graph
          (send graph	:use-color t)
          (send graph :plot-buttons :new-x t :new-y t :free nil :mouse-mode nil)
          (when points
                (send graph :point-color (iseq (send graph :num-points)) 'blue)
                (send graph :mouse-mode 'brushing))
          (send graph :x-axis t t (third (send graph :x-axis)))
          (send graph :y-axis t t (third (send graph :y-axis)))
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          (send graph :make-two-plot-menus
                "CumPlot"
                :hotspot-items '(help dash new-x new-y dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all unselect-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable linked
                data-object content-only)
          )
    graph))



(defun comparison-plot 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels  variable-label
             (show t) (top-most t) (linked t) (connect t) 
             (location '(50 50)) (size '(320 320))
             (title "Comparison Plot") 
             (legend1 "Unnamed Data") (legend2 nil)
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???)
             ;following are unique to this plot
             (reg-line t) (points nil) nice-x-range nice-y-range)
             
"COMPARISON PLOT makes quantile-quantile plots which can be used to compare the shape of the distribtions of two numeric variables.

ARGUMENTS:
&optional data &key (points t) (reg-line t) (ok-var-types '(numeric )) variable-labels  point-labels (show t) (top-most t) (linked t) (connect t) (location '(50 50)) (size '(320 320)) (title \"Comparison Plot\") (legend1 (send $ :name)) (legend2 (send self :title)) (content-only nil) 

DATA is nil, a data object, a list of two sequences (LIST XDATA YDATA), or two sequences  XDATA YDATA. In the latter case, the two sequences do not have to be the same length. When DATA is NIL the current data object is used. When  a data object is used the first two numeric variables are used. Makes a quantile-quantile plot of the two sequences.  By default a line plot is produced. Points are added if POINTS is T. When REG-LINE is t a regression line is added to the plot."

  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types))
         (data-object (fourth graph-data))
         (linkable nil)
         (xdata)
         (ydata)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 "Quantile-Quantile Plot"))
    (setf xdata (first graph-data))
    (setf ydata (second graph-data))
    (setf graph 
          (send quantile-quantile-plot-proto :new xdata ydata :reg-line reg-line 
                 :nice-x-range nice-x-range :nice-y-range nice-y-range
                 :title title :point-labels point-labels
                 :legend1 legend1 :legend2 legend2
                 :show-points-and-menu points
                 :variable-labels variable-labels :location location 
                 :size size :go-away go-away :show nil :in in :in? in? ))
    (when graph
          ;(send graph :use-color t)
          (send graph :plot-buttons :new-x t :new-y t :free nil :mouse-mode points)
          (when points
                (send graph :point-color (iseq (send graph :num-points)) 'blue)
                (send graph :mouse-mode 'brushing))
          ;(send graph :x-axis t t (third (send graph :x-axis)))
          ;(send graph :y-axis t t (third (send graph :y-axis)))
          
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          (send graph :make-two-plot-menus "Compare" 
                :hotspot-items '(help dash new-x new-y dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(no-items))
          (send graph :after-new-plot 
                pop-out top-most show size actcon linkable linked
                data-object content-only))
    graph))
